/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.button;

import javax.annotation.Nonnull;
import net.dries007.tfc.client.TFCGuiHandler;
import net.dries007.tfc.client.button.GuiButtonTFC;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class GuiButtonPlayerInventoryTab
extends GuiButtonTFC {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("tfc", "textures/gui/icons.png");
    private final TFCGuiHandler.Type guiType;
    private final boolean isActive;
    private final int textureU;
    private final int textureV;
    private final int iconU;
    private final int iconV;
    private final int iconY;
    private int renderWidth;
    private int iconX;
    private int guiLeft;

    public GuiButtonPlayerInventoryTab(TFCGuiHandler.Type guiType, int guiLeft, int guiTop, int buttonId, boolean isActive) {
        super(buttonId, guiLeft + 176, guiTop, 20, 22, "");
        this.guiType = guiType;
        this.isActive = isActive;
        this.guiLeft = guiLeft;
        switch (guiType) {
            case INVENTORY: {
                this.field_146129_i += 4;
                this.iconU = 0;
                break;
            }
            case SKILLS: {
                this.field_146129_i += 27;
                this.iconU = 32;
                break;
            }
            case CALENDAR: {
                this.field_146129_i += 50;
                this.iconU = 64;
                break;
            }
            case NUTRITION: {
                this.field_146129_i += 73;
                this.iconU = 96;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid gui type: " + (Object)((Object)guiType));
            }
        }
        this.renderWidth = 20;
        this.iconV = 0;
        this.textureV = 0;
        this.iconX = this.field_146128_h + 1;
        this.iconY = this.field_146129_i + 3;
        if (isActive) {
            this.textureU = 128;
        } else {
            this.field_146128_h -= 3;
            this.renderWidth += 3;
            this.textureU = 148;
        }
    }

    public void updateGuiLeft(int newGuiLeft) {
        this.field_146128_h += newGuiLeft - this.guiLeft;
        this.iconX += newGuiLeft - this.guiLeft;
        this.guiLeft = newGuiLeft;
        this.field_146124_l = false;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public TFCGuiHandler.Type getGuiType() {
        return this.guiType;
    }

    public void func_191745_a(@Nonnull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        if (this.field_146125_m) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mc.func_110434_K().func_110577_a(BACKGROUND);
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            GuiButtonPlayerInventoryTab.func_146110_a((int)this.field_146128_h, (int)this.field_146129_i, (float)this.textureU, (float)this.textureV, (int)this.renderWidth, (int)22, (float)256.0f, (float)256.0f);
            GuiButtonPlayerInventoryTab.func_152125_a((int)this.iconX, (int)this.iconY, (float)this.iconU, (float)this.iconV, (int)32, (int)32, (int)16, (int)16, (float)256.0f, (float)256.0f);
            this.func_146119_b(mc, mouseX, mouseY);
            this.field_146124_l = true;
        }
    }
}

